# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from .sdresource import SDResource
from .sdarray import SDArray
from .sdmetadatadict import SDMetadataDict
from .sdpackagedependency import SDPackageDependency
from .sdapiobject import SDAPIObject
from .sdresource import EmbedMethod
from .sdapiobject import SDApiError
from .apiexception import APIException

class SDPackage(SDAPIObject):
    """
    A package that can contains SDResource
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDPackage
        """
        super(SDPackage, self).__init__(APIContext, handle, *args, **kwargs)

    def getFilePath(self) -> str:
        """
        Get the package file path

        """
        outFilePath = ctypes.c_char_p()
        _res = self.mAPIContext.SDPackage_getFilePath(self.mHandle, ctypes.byref(outFilePath))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outFilePath.value.decode('utf-8') # type: ignore

    def getUID(self) -> str:
        """
        Get the package UID

        """
        outUID = ctypes.c_char_p()
        _res = self.mAPIContext.SDPackage_getUID(self.mHandle, ctypes.byref(outUID))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outUID.value.decode('utf-8') # type: ignore

    def findResourceFromUrl(self, sdResourceUrl : str) -> Optional[SDResource]:
        """
        Retrieve the SDResource that matches the specified resource-URL. The URL can be of different formats, and is relative to the current SDPackage: "pkg:///A/B/MyResource?dependency=XXXXXX" (in a different package), "pkg:///A/B/MyResource" (in the same package), "A/B/MyResource" (on filesystem)

        :param sdResourceUrl: The URL of the resource to retrieve
        """
        outSDResource = ctypes.c_void_p()
        _res = self.mAPIContext.SDPackage_findResourceFromUrl(self.mHandle, ctypes.create_string_buffer(sdResourceUrl.encode('utf-8')), ctypes.byref(outSDResource))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDResource, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDResource.value, ownHandle=True)

    def getChildrenResources(self, isRecursive : bool) -> Optional[SDArray[SDResource]]:
        """
        Retrieve resources under the current package

        :param isRecursive: If True then all resources at all levels are flattened in 'outArray', otherwise only the direct children of the package are retrieved
        """
        outArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDPackage_getChildrenResources(self.mHandle, isRecursive, ctypes.byref(outArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outArray.value, ownHandle=True)

    def getMetadataDict(self) -> SDMetadataDict:
        """
        Get the metadata of this package as a SDMetadataDict.

        """
        outSDMetadataDict = ctypes.c_void_p()
        _res = self.mAPIContext.SDPackage_getMetadataDict(self.mHandle, ctypes.byref(outSDMetadataDict))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDMetadataDict, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDMetadataDict.value, ownHandle=True)

    def getDependencies(self) -> SDArray[SDPackageDependency]:
        """
        Get the SDPackage dependencies

        """
        outSDArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDPackage_getDependencies(self.mHandle, ctypes.byref(outSDArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDArray.value, ownHandle=True)

    def isModified(self) -> bool:
        """
        Return True if the package is modified.

        """
        outIsModified = ctypes.c_bool()
        _res = self.mAPIContext.SDPackage_isModified(self.mHandle, ctypes.byref(outIsModified))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outIsModified.value

